/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import net.nooj4nlp.engine.AmbiguitiesUnambiguitiesObject;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TransitionObject;
import net.nooj4nlp.engine.TransitionPair;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Mft
implements Serializable {
    private static final long serialVersionUID = -7338281112909884406L;
    public int[] tuAddresses;
    public transient int[] tuLengths;
    public transient ArrayList<ArrayList<TransitionObject>> aTransitions;
    public transient int nbOfTransitions;
    private int maxRelBegAddress;
    private int maxLenAddress;
    private int maxTokenId;
    private int nboftransitions;
    private int[] nbOfTransPerTu;
    private short[] trans_beg_s;
    private int[] trans_beg_i;
    private byte[] trans_end_b;
    private short[] trans_end_s;
    private int[] trans_end_i;
    private short[] trans_tok_s;
    private int[] trans_tok_i;
    private short[] lengths_s;
    private int[] lengths_i;

    public Mft(int nbOfTus) {
        this.tuAddresses = new int[nbOfTus + 1];
        this.tuLengths = new int[nbOfTus + 1];
        this.aTransitions = new ArrayList();
        this.aTransitions.add(null);
        for (int itu = 1; itu < nbOfTus + 1; ++itu) {
            this.aTransitions.add(new ArrayList());
        }
        this.maxTokenId = 0;
        this.nboftransitions = 0;
        this.maxLenAddress = 0;
        this.maxRelBegAddress = 0;
        this.nbOfTransitions = 0;
    }

    public final void resetTransitions() {
        for (int itu = 1; itu < this.aTransitions.size(); ++itu) {
            this.aTransitions.set(itu, new ArrayList());
        }
        this.maxTokenId = 0;
        this.nboftransitions = 0;
        this.nbOfTransitions = 0;
    }

    final void reSize(int newNbOfTus) {
        if (newNbOfTus > this.tuAddresses.length - 1) {
            return;
        }
        int[] newTuAddresses = new int[newNbOfTus + 1];
        for (int i = 1; i <= newNbOfTus; ++i) {
            newTuAddresses[i] = this.tuAddresses[i];
        }
        this.tuAddresses = newTuAddresses;
        int[] newtuLengths = new int[newNbOfTus + 1];
        for (int i = 1; i <= newNbOfTus; ++i) {
            newtuLengths[i] = this.tuLengths[i];
        }
        this.tuLengths = newtuLengths;
        ArrayList<ArrayList<TransitionObject>> newaTransitions = new ArrayList<ArrayList<TransitionObject>>(newNbOfTus + 1);
        newaTransitions.add(null);
        for (int i = 1; i <= newNbOfTus; ++i) {
            newaTransitions.add(this.aTransitions.get(i));
        }
        this.aTransitions = newaTransitions;
    }

    public final TuGraph getTuGraph(int tuNb, TuGraph tuGraphToBeUpdated) {
        if (tuGraphToBeUpdated == null) {
            tuGraphToBeUpdated = new TuGraph();
        } else {
            tuGraphToBeUpdated.transitions.clear();
            tuGraphToBeUpdated.setTransitions(new ArrayList<ArrayList<TuGraph.TransCell>>());
            tuGraphToBeUpdated.stPositions.clear();
        }
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        for (int it = 0; it < transitions.size(); ++it) {
            double relbegaddress = transitions.get(it).getRelBegAddress();
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            for (int io = 0; io < outgoings.size(); ++io) {
                int tokenId = outgoings.get(io).getTokenId();
                double relEndAddress = outgoings.get(io).getRelEndAddress();
                tuGraphToBeUpdated.addTransition(relbegaddress, tokenId, relEndAddress);
            }
        }
        return tuGraphToBeUpdated;
    }

    public final boolean removeTransition(int tuNb, double theRelBegAddress, int theTokenId, RefObject<Double> relEndAddress) {
        ParameterCheck.mandatory("relEndAddress", relEndAddress);
        relEndAddress.argvalue = 0.0;
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        for (int it = 0; it < transitions.size(); ++it) {
            double relBegAddress = transitions.get(it).getRelBegAddress();
            if (relBegAddress != theRelBegAddress) continue;
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            for (int io = 0; io < outgoings.size(); ++io) {
                int tokenId = outgoings.get(io).getTokenId();
                if (tokenId != theTokenId) continue;
                Double newRelEndAddressValue = outgoings.get(io).getRelEndAddress();
                relEndAddress.argvalue = newRelEndAddressValue;
                outgoings.remove(io);
                --this.nbOfTransitions;
                return true;
            }
        }
        return false;
    }

    final ArrayList<AmbiguitiesUnambiguitiesObject> getAllAmbiguitiesInTextUnit(int tuNb) {
        ArrayList<AmbiguitiesUnambiguitiesObject> ambiguities = new ArrayList<AmbiguitiesUnambiguitiesObject>();
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        for (int it = 0; it < transitions.size(); ++it) {
            double relBegAddress;
            double relEndAddress = relBegAddress = transitions.get(it).getRelBegAddress().doubleValue();
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            if (outgoings.size() <= 1) continue;
            ArrayList<Integer> tokenIds = new ArrayList<Integer>();
            for (int io = 0; io < outgoings.size(); ++io) {
                int tokenId = outgoings.get(io).getTokenId();
                tokenIds.add(tokenId);
                double end = outgoings.get(io).getRelEndAddress();
                if (!(relEndAddress < end)) continue;
                relEndAddress = end;
            }
            Collections.sort(tokenIds);
            ambiguities.add(new AmbiguitiesUnambiguitiesObject(relBegAddress, tokenIds, relEndAddress));
        }
        return ambiguities;
    }

    final ArrayList<AmbiguitiesUnambiguitiesObject> getAllUnambiguitiesInTextUnit(int tuNb) {
        ArrayList<AmbiguitiesUnambiguitiesObject> unambiguities = new ArrayList<AmbiguitiesUnambiguitiesObject>();
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        for (int it = 0; it < transitions.size(); ++it) {
            double relBegAddress;
            double relEndAddress = relBegAddress = transitions.get(it).getRelBegAddress().doubleValue();
            ArrayList<TransitionPair> outgoings = transitions.get(it).getOutgoings();
            if (outgoings.size() != 1) continue;
            ArrayList<Integer> tokenIds = new ArrayList<Integer>();
            for (int io = 0; io < outgoings.size(); ++io) {
                int tokenId = outgoings.get(io).getTokenId();
                tokenIds.add(tokenId);
                double end = outgoings.get(io).getRelEndAddress();
                if (!(relEndAddress < end)) continue;
                relEndAddress = end;
            }
            Collections.sort(tokenIds);
            unambiguities.add(new AmbiguitiesUnambiguitiesObject(relBegAddress, tokenIds, relEndAddress));
        }
        return unambiguities;
    }

    final double getANewVirginAddress(int tuNb, double relBegAddress, double relEndAddress) {
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        double largest = relBegAddress;
        for (int i = 0; i < transitions.size(); ++i) {
            double current = transitions.get(i).getRelBegAddress();
            if (!(current >= relBegAddress) || !(current < relEndAddress) || !(current > largest)) continue;
            largest = current;
        }
        int zz = (int)((largest + 0.005) * 100.0) + 1;
        largest = (double)zz / 100.0;
        return largest;
    }

    final ArrayList<TransitionPair> getOutgoingTransitions(int tuNb, double relBegAddress) {
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        for (int i = 0; i < transitions.size(); ++i) {
            if (transitions.get(i).getRelBegAddress() != relBegAddress) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        return transitions.get(index).getOutgoings();
    }

    final void shiftAllTransitions(int[] shift) {
        int itu;
        ParameterCheck.mandatory("shift", shift);
        int[] newAddresses = new int[this.tuAddresses.length];
        int[] newLengths = new int[this.tuLengths.length];
        for (itu = 0; itu < this.tuAddresses.length; ++itu) {
            int tuAddress = this.tuAddresses[itu];
            int newAddress = shift[tuAddress];
            int tuLength = this.tuLengths[itu];
            int end = tuAddress + tuLength;
            int newend = shift[end];
            int newLength = newend - newAddress;
            newAddresses[itu] = newAddress;
            newLengths[itu] = newLength;
        }
        for (itu = 0; itu < this.tuAddresses.length; ++itu) {
            ArrayList<TransitionObject> transitions = this.aTransitions.get(itu);
            if (transitions == null) continue;
            int startAdd = this.tuAddresses[itu];
            for (int i = 0; i < transitions.size(); ++i) {
                double relBeg = transitions.get(i).getRelBegAddress();
                double beg = relBeg + (double)startAdd;
                int iBeg = (int)beg;
                double rBeg = beg - (double)iBeg;
                double newBeg = (double)shift[iBeg] + rBeg;
                transitions.get(i).setRelBegAddress(newBeg - (double)newAddresses[itu]);
                ArrayList<TransitionPair> outgoings = transitions.get(i).getOutgoings();
                for (int j = 0; j < outgoings.size(); ++j) {
                    double relEnd = outgoings.get(j).getRelEndAddress();
                    double end = relEnd + (double)startAdd;
                    int iEnd = (int)end;
                    double rEnd = end - (double)iEnd;
                    double newEnd = (double)shift[iEnd] + rEnd;
                    outgoings.get(j).setRelEndAddress(newEnd - (double)newAddresses[itu]);
                }
            }
        }
        for (itu = 0; itu < this.tuAddresses.length; ++itu) {
            this.tuAddresses[itu] = newAddresses[itu];
            this.tuLengths[itu] = newLengths[itu];
        }
    }

    public final void addTransition(int tuNb, double relBegAddress, int tokenId, double relEndAddress) {
        if (relBegAddress > (double)this.maxRelBegAddress) {
            this.maxRelBegAddress = (int)relBegAddress;
        }
        if (relEndAddress - relBegAddress > (double)this.maxLenAddress) {
            this.maxLenAddress = (int)(relEndAddress - relBegAddress);
        }
        if (tokenId > this.maxTokenId) {
            this.maxTokenId = tokenId;
        }
        ++this.nboftransitions;
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        for (int i = 0; i < transitions.size(); ++i) {
            if (transitions.get(i).getRelBegAddress() != relBegAddress) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = transitions.size();
            transitions.add(new TransitionObject(relBegAddress, new ArrayList<TransitionPair>()));
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            outgoings.add(new TransitionPair(tokenId, relEndAddress));
            transitions.get(index).setOutgoings(outgoings);
            ++this.nbOfTransitions;
        } else {
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            boolean alreadyThere = false;
            for (int io = 0; io < outgoings.size(); ++io) {
                int tid = outgoings.get(io).getTokenId();
                double rel = outgoings.get(io).getRelEndAddress();
                if (tokenId != tid || relEndAddress != rel) continue;
                alreadyThere = true;
                break;
            }
            if (!alreadyThere) {
                outgoings.add(new TransitionPair(tokenId, relEndAddress));
                ++this.nbOfTransitions;
            }
        }
    }

    final void deleteNonXrefsAndAddTransition(int tuNb, double relBegAddress, int tokenId, ArrayList<Object> annotations, double relEndAddress) {
        ParameterCheck.mandatoryCollection("annotations", annotations);
        if (relBegAddress > (double)this.maxRelBegAddress) {
            this.maxRelBegAddress = (int)relBegAddress;
        }
        if (relEndAddress - relBegAddress > (double)this.maxLenAddress) {
            this.maxLenAddress = (int)(relEndAddress - relBegAddress);
        }
        if (tokenId > this.maxTokenId) {
            this.maxTokenId = tokenId;
        }
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        for (int i = 0; i < transitions.size(); ++i) {
            if (transitions.get(i).getRelBegAddress() != relBegAddress) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = transitions.size();
            transitions.add(new TransitionObject(relBegAddress, new ArrayList<TransitionPair>()));
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            outgoings.add(new TransitionPair(tokenId, relEndAddress));
            transitions.get(index).setOutgoings(outgoings);
            ++this.nbOfTransitions;
        } else {
            ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
            outgoings.add(new TransitionPair(tokenId, relEndAddress));
            ++this.nbOfTransitions;
        }
    }

    public final int filterTransitions(ArrayList<Object> annotations, int tuNb, double relBegAddress, String symbol, RefObject<Boolean> anXrefWasRemoved) {
        ParameterCheck.mandatoryCollection("annotations", annotations);
        ParameterCheck.mandatoryString("symbol", symbol);
        ParameterCheck.mandatory("anXrefWasRemoved", anXrefWasRemoved);
        anXrefWasRemoved.argvalue = false;
        int nbOfRemoved = 0;
        String entry = null;
        String lemma = null;
        String category = null;
        String[] features = null;
        boolean negation = false;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
        boolean tempVar = !Dic.parseSymbolFeatureArray(symbol, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        negation = (Boolean)tempRef_negation.argvalue;
        if (tempVar) {
            return nbOfRemoved;
        }
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        for (int i = 0; i < transitions.size(); ++i) {
            if (transitions.get(i).getRelBegAddress() != relBegAddress) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return nbOfRemoved;
        }
        ArrayList<TransitionPair> initialTrans = transitions.get(index).getOutgoings();
        if (initialTrans.isEmpty()) {
            return nbOfRemoved;
        }
        ArrayList<TransitionPair> outgoings = new ArrayList<TransitionPair>(initialTrans);
        for (int io = 0; io < outgoings.size(); ++io) {
            String val;
            boolean match;
            boolean anxref = false;
            int tkId = outgoings.get(io).getTokenId();
            String lbl = (String)annotations.get(tkId);
            if (lbl == null) continue;
            String lEntry = null;
            RefObject<Object> tempRef_lEntry = new RefObject<Object>(lEntry);
            String lLemma = null;
            RefObject<Object> tempRef_lLemma = new RefObject<Object>(lLemma);
            String lCategory = null;
            RefObject<Object> tempRef_lCategory = new RefObject<Object>(lCategory);
            String[] lFeatures = null;
            RefObject<Object> tempRef_lfeatures = new RefObject<Object>(lFeatures);
            boolean tempVar2 = !Dic.parseDELAF(lbl, tempRef_lEntry, tempRef_lLemma, null, tempRef_lCategory, null, tempRef_lfeatures);
            lEntry = (String)tempRef_lEntry.argvalue;
            lLemma = (String)tempRef_lLemma.argvalue;
            lCategory = (String)tempRef_lCategory.argvalue;
            lFeatures = (String[])tempRef_lfeatures.argvalue;
            if (tempVar2) continue;
            if (!negation) {
                if (entry != null && !entry.equals(lEntry)) {
                    outgoings.remove(io);
                    --this.nbOfTransitions;
                    if (anxref) {
                        anXrefWasRemoved.argvalue = true;
                    }
                    ++nbOfRemoved;
                    --io;
                    continue;
                }
                if (lemma != null && !lemma.equals(lLemma)) {
                    outgoings.remove(io);
                    --this.nbOfTransitions;
                    if (anxref) {
                        anXrefWasRemoved.argvalue = true;
                    }
                    ++nbOfRemoved;
                    --io;
                    continue;
                }
                if (category != null && !category.equals(lCategory) && !category.equals("DIC")) {
                    outgoings.remove(io);
                    --this.nbOfTransitions;
                    if (anxref) {
                        anXrefWasRemoved.argvalue = true;
                    }
                    ++nbOfRemoved;
                    --io;
                    continue;
                }
                if (features == null) continue;
                match = false;
                for (String feature : features) {
                    if (feature.charAt(0) == '+') {
                        match = false;
                        if (lFeatures != null) {
                            for (String lfeature : lFeatures) {
                                if (lfeature.equals(feature.substring(1))) {
                                    match = true;
                                    break;
                                }
                                if (lfeature.indexOf(61) == -1 || !(val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) continue;
                                match = true;
                                break;
                            }
                        }
                        if (match) continue;
                        break;
                    }
                    match = true;
                    if (lFeatures != null) {
                        for (String lfeature : lFeatures) {
                            if (lfeature.equals(feature.substring(1))) {
                                match = false;
                                break;
                            }
                            if (lfeature.indexOf(61) == -1 || !(val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) continue;
                            match = false;
                            break;
                        }
                    }
                    if (!match) break;
                }
                if (match) continue;
                outgoings.remove(io);
                --this.nbOfTransitions;
                if (anxref) {
                    anXrefWasRemoved.argvalue = true;
                }
                ++nbOfRemoved;
                --io;
                continue;
            }
            if (entry != null) {
                if (!entry.equals(lEntry)) {
                    continue;
                }
            } else if (lemma == null ? category != null && !category.equals(lCategory) : !lemma.equals(lLemma)) continue;
            if (features == null) {
                outgoings.remove(io);
                --this.nbOfTransitions;
                if (anxref) {
                    anXrefWasRemoved.argvalue = true;
                }
                ++nbOfRemoved;
                --io;
                continue;
            }
            match = false;
            for (String feature : features) {
                if (feature.charAt(0) == '+') {
                    match = false;
                    if (lFeatures != null) {
                        for (String lfeature : lFeatures) {
                            if (lfeature.equals(feature.substring(1))) {
                                match = true;
                                break;
                            }
                            if (lfeature.indexOf(61) == -1 || !(val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) continue;
                            match = true;
                            break;
                        }
                    }
                    if (match) continue;
                    break;
                }
                match = true;
                if (lFeatures != null) {
                    for (String lfeature : lFeatures) {
                        if (lfeature.equals(feature.substring(1))) {
                            match = false;
                            break;
                        }
                        if (lfeature.indexOf(61) == -1 || !(val = lfeature.substring(lfeature.indexOf(61) + 1)).equals(feature.substring(1))) continue;
                        match = false;
                        break;
                    }
                }
                if (!match) break;
            }
            if (!match) continue;
            outgoings.remove(io);
            --this.nbOfTransitions;
            if (anxref) {
                anXrefWasRemoved.argvalue = true;
            }
            ++nbOfRemoved;
            --io;
        }
        if (outgoings.size() > 0) {
            transitions.get(index).setOutgoings(outgoings);
        }
        return nbOfRemoved;
    }

    final boolean thereAreLexs(int tuNb, double relBegAddress) {
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        for (int i = 0; i < transitions.size(); ++i) {
            if (transitions.get(i).getRelBegAddress() != relBegAddress) continue;
            return true;
        }
        return false;
    }

    final int getAllLexIds(int tuNb, double relBegAddress, RefObject<ArrayList<Integer>> lexIds, RefObject<ArrayList<Double>> fLengths) {
        ParameterCheck.mandatory("lexIds", lexIds);
        ParameterCheck.mandatory("fLengths", fLengths);
        lexIds.argvalue = null;
        fLengths.argvalue = null;
        ArrayList<TransitionPair> outgoings = this.getOutgoingTransitions(tuNb, relBegAddress);
        if (outgoings == null) {
            return 0;
        }
        for (int io = 0; io < outgoings.size(); ++io) {
            if (lexIds.argvalue == null) {
                lexIds.argvalue = new ArrayList();
                fLengths.argvalue = new ArrayList();
            }
            ((ArrayList)lexIds.argvalue).add(outgoings.get(io).getTokenId());
            long hund_len = (long)(100.0 * outgoings.get(io).getRelEndAddress()) - (long)(100.0 * relBegAddress);
            double len = (double)hund_len / 100.0;
            ((ArrayList)fLengths.argvalue).add(len);
        }
        if (lexIds.argvalue == null) {
            return 0;
        }
        int iLex = 1;
        while (iLex < ((ArrayList)lexIds.argvalue).size()) {
            int lexId = (Integer)((ArrayList)lexIds.argvalue).get(iLex);
            double len = (Double)((ArrayList)fLengths.argvalue).get(iLex);
            boolean found = false;
            for (int jLex = 0; jLex < iLex; ++jLex) {
                int jLexId = (Integer)((ArrayList)lexIds.argvalue).get(jLex);
                double jlen = (Double)((ArrayList)fLengths.argvalue).get(jLex);
                if (lexId != jLexId || len != jlen) continue;
                found = true;
                break;
            }
            if (found) {
                ((ArrayList)lexIds.argvalue).remove(iLex);
                ((ArrayList)fLengths.argvalue).remove(iLex);
                continue;
            }
            ++iLex;
        }
        return ((ArrayList)lexIds.argvalue).size();
    }

    final int getAllLexIdsAndContracted(int tuNb, double relBegAddress, RefObject<ArrayList<Integer>> lexIds, RefObject<ArrayList<Double>> fLengths) {
        ParameterCheck.mandatory("lexIds", lexIds);
        ParameterCheck.mandatory("fLengths", fLengths);
        lexIds.argvalue = null;
        fLengths.argvalue = null;
        ArrayList<TransitionObject> transitions = this.aTransitions.get(tuNb);
        int index = -1;
        for (int i = 0; i < transitions.size(); ++i) {
            if (transitions.get(i).getRelBegAddress() != relBegAddress) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return 0;
        }
        ArrayList<TransitionPair> outgoings = transitions.get(index).getOutgoings();
        for (int io = 0; io < outgoings.size(); ++io) {
            if (lexIds.argvalue == null) {
                lexIds.argvalue = new ArrayList();
                fLengths.argvalue = new ArrayList();
            }
            ((ArrayList)lexIds.argvalue).add(outgoings.get(io).getTokenId());
            double len = outgoings.get(io).getRelEndAddress() - relBegAddress;
            ((ArrayList)fLengths.argvalue).add(len);
        }
        if (lexIds.argvalue == null) {
            return 0;
        }
        double relBegAddress2 = relBegAddress;
        do {
            relBegAddress2 += 0.01;
            index = -1;
            for (int i = 0; i < transitions.size(); ++i) {
                if (transitions.get(i).getRelBegAddress() != relBegAddress2) continue;
                index = i;
                break;
            }
            if (index == -1) continue;
            outgoings = transitions.get(index).getOutgoings();
            for (int io = 0; io < outgoings.size(); ++io) {
                ((ArrayList)lexIds.argvalue).add(outgoings.get(io).getTokenId());
                double len = outgoings.get(io).getRelEndAddress() - relBegAddress;
                ((ArrayList)fLengths.argvalue).add(len);
            }
        } while (index != -1);
        int iLex = 1;
        while (iLex < ((ArrayList)lexIds.argvalue).size()) {
            int lexId = (Integer)((ArrayList)lexIds.argvalue).get(iLex);
            double len = (Double)((ArrayList)fLengths.argvalue).get(iLex);
            boolean found = false;
            for (int jLex = 0; jLex < iLex; ++jLex) {
                int jlexid = (Integer)((ArrayList)lexIds.argvalue).get(jLex);
                double jlen = (Double)((ArrayList)fLengths.argvalue).get(jLex);
                if (lexId != jlexid || len != jlen) continue;
                found = true;
                break;
            }
            if (found) {
                ((ArrayList)lexIds.argvalue).remove(iLex);
                ((ArrayList)fLengths.argvalue).remove(iLex);
                continue;
            }
            ++iLex;
        }
        return ((ArrayList)lexIds.argvalue).size();
    }

    public final void beforeSaving() {
        int tokenId;
        int len;
        int relendaddress;
        int k;
        int j;
        int itu;
        int k2;
        ArrayList<TransitionPair> state;
        int j2;
        ArrayList<TransitionObject> trans;
        int itu2;
        int i;
        this.lengths_s = null;
        this.lengths_i = null;
        int maxLength = 0;
        for (i = 0; i < this.tuLengths.length; ++i) {
            if (this.tuLengths[i] <= maxLength) continue;
            maxLength = this.tuLengths[i];
        }
        if (maxLength < Short.MAX_VALUE) {
            this.lengths_s = new short[this.tuLengths.length];
            for (i = 0; i < this.tuLengths.length; ++i) {
                this.lengths_s[i] = (short)this.tuLengths[i];
            }
        } else {
            this.lengths_i = new int[this.tuLengths.length];
            for (i = 0; i < this.tuLengths.length; ++i) {
                this.lengths_i[i] = this.tuLengths[i];
            }
        }
        this.nbOfTransPerTu = new int[this.aTransitions.size()];
        this.trans_beg_s = null;
        this.trans_beg_i = null;
        int ibeg = 0;
        if (this.maxRelBegAddress * 100 < Short.MAX_VALUE) {
            this.trans_beg_s = new short[this.nboftransitions];
            for (itu2 = 1; itu2 < this.aTransitions.size(); ++itu2) {
                this.nbOfTransPerTu[itu2] = 0;
                trans = this.aTransitions.get(itu2);
                for (j2 = 0; j2 < trans.size(); ++j2) {
                    short relbegaddress = (short)(trans.get(j2).getRelBegAddress() * 100.0);
                    state = trans.get(j2).getOutgoings();
                    for (k2 = 0; k2 < state.size(); ++k2) {
                        this.trans_beg_s[ibeg++] = relbegaddress;
                        int n = itu2;
                        this.nbOfTransPerTu[n] = this.nbOfTransPerTu[n] + 1;
                    }
                }
            }
        } else {
            this.trans_beg_i = new int[this.nboftransitions];
            for (itu2 = 1; itu2 < this.aTransitions.size(); ++itu2) {
                this.nbOfTransPerTu[itu2] = 0;
                trans = this.aTransitions.get(itu2);
                for (j2 = 0; j2 < trans.size(); ++j2) {
                    int relBegAddress = (int)(trans.get(j2).getRelBegAddress() * 100.0);
                    state = trans.get(j2).getOutgoings();
                    for (k2 = 0; k2 < state.size(); ++k2) {
                        this.trans_beg_i[ibeg++] = relBegAddress;
                        int n = itu2;
                        this.nbOfTransPerTu[n] = this.nbOfTransPerTu[n] + 1;
                    }
                }
            }
        }
        this.trans_end_b = null;
        this.trans_end_s = null;
        this.trans_end_i = null;
        int iend = 0;
        if (this.maxLenAddress * 100 < 127) {
            this.trans_end_b = new byte[this.nboftransitions];
            for (itu = 1; itu < this.aTransitions.size(); ++itu) {
                ArrayList<TransitionObject> trans2 = this.aTransitions.get(itu);
                for (j = 0; j < trans2.size(); ++j) {
                    int relbegaddress = (int)(100.0 * trans2.get(j).getRelBegAddress());
                    ArrayList<TransitionPair> state2 = trans2.get(j).getOutgoings();
                    for (k = 0; k < state2.size(); ++k) {
                        relendaddress = (int)(100.0 * state2.get(k).getRelEndAddress());
                        len = relendaddress - relbegaddress;
                        this.trans_end_b[iend++] = (byte)len;
                    }
                }
            }
        } else if (this.maxLenAddress < Short.MAX_VALUE) {
            this.trans_end_s = new short[this.nboftransitions];
            for (itu = 1; itu < this.aTransitions.size(); ++itu) {
                ArrayList<TransitionObject> trans3 = this.aTransitions.get(itu);
                for (j = 0; j < trans3.size(); ++j) {
                    int relbegaddress = (int)(100.0 * trans3.get(j).getRelBegAddress());
                    ArrayList<TransitionPair> state3 = trans3.get(j).getOutgoings();
                    for (k = 0; k < state3.size(); ++k) {
                        int relEndAddress = (int)(100.0 * state3.get(k).getRelEndAddress());
                        len = relEndAddress - relbegaddress;
                        this.trans_end_s[iend++] = (short)len;
                    }
                }
            }
        } else {
            this.trans_end_i = new int[this.nboftransitions];
            for (itu = 1; itu < this.aTransitions.size(); ++itu) {
                ArrayList<TransitionObject> trans4 = this.aTransitions.get(itu);
                for (j = 0; j < trans4.size(); ++j) {
                    int relbegaddress = (int)(100.0 * trans4.get(j).getRelBegAddress());
                    ArrayList<TransitionPair> state4 = trans4.get(j).getOutgoings();
                    for (k = 0; k < state4.size(); ++k) {
                        relendaddress = (int)(100.0 * state4.get(k).getRelEndAddress());
                        len = relendaddress - relbegaddress;
                        this.trans_end_i[iend++] = len;
                    }
                }
            }
        }
        this.trans_tok_s = null;
        this.trans_tok_i = null;
        int itok = 0;
        if (this.maxTokenId < Short.MAX_VALUE) {
            this.trans_tok_s = new short[this.nboftransitions];
            for (int itu3 = 1; itu3 < this.aTransitions.size(); ++itu3) {
                ArrayList<TransitionObject> trans5 = this.aTransitions.get(itu3);
                for (int j3 = 0; j3 < trans5.size(); ++j3) {
                    ArrayList<TransitionPair> state5 = trans5.get(j3).getOutgoings();
                    for (k = 0; k < state5.size(); ++k) {
                        tokenId = state5.get(k).getTokenId();
                        this.trans_tok_s[itok++] = (short)tokenId;
                    }
                }
            }
        } else {
            this.trans_tok_i = new int[this.nboftransitions];
            for (int itu4 = 1; itu4 < this.aTransitions.size(); ++itu4) {
                ArrayList<TransitionObject> trans6 = this.aTransitions.get(itu4);
                for (int j4 = 0; j4 < trans6.size(); ++j4) {
                    ArrayList<TransitionPair> state6 = trans6.get(j4).getOutgoings();
                    for (k = 0; k < state6.size(); ++k) {
                        tokenId = state6.get(k).getTokenId();
                        this.trans_tok_i[itok++] = tokenId;
                    }
                }
            }
        }
    }

    final void afterLoading(double divider) {
        int i;
        if (divider == 0.0) {
            divider = 10.0;
        }
        if (this.lengths_s != null) {
            this.tuLengths = new int[this.lengths_s.length];
            for (i = 0; i < this.lengths_s.length; ++i) {
                this.tuLengths[i] = this.lengths_s[i];
            }
            this.lengths_s = null;
        } else {
            this.tuLengths = new int[this.lengths_i.length];
            for (i = 0; i < this.lengths_i.length; ++i) {
                this.tuLengths[i] = this.lengths_i[i];
            }
            this.lengths_i = null;
        }
        this.aTransitions = new ArrayList();
        int originalNbOfTransitions = this.nboftransitions;
        if (originalNbOfTransitions == 0) {
            this.aTransitions.add(null);
            for (int itu = 1; itu < this.tuAddresses.length; ++itu) {
                this.aTransitions.add(new ArrayList());
            }
        } else {
            int iTrans = 0;
            double relBegAddress = this.trans_beg_s != null ? (double)this.trans_beg_s[0] / divider : (double)this.trans_beg_i[0] / divider;
            double relEndAddress = this.trans_end_b != null ? relBegAddress + (double)this.trans_end_b[0] / divider : (this.trans_end_s != null ? relBegAddress + (double)this.trans_end_s[0] / divider : relBegAddress + (double)this.trans_end_i[0] / divider);
            int tokenId = this.trans_tok_s != null ? this.trans_tok_s[0] : this.trans_tok_i[0];
            this.aTransitions.add(null);
            block3: for (int itu = 1; itu < this.tuAddresses.length; ++itu) {
                this.aTransitions.add(new ArrayList());
                for (int jtrans = 0; jtrans < this.nbOfTransPerTu[itu]; ++jtrans) {
                    this.addTransition(itu, relBegAddress, tokenId, relEndAddress);
                    if (++iTrans >= originalNbOfTransitions) continue block3;
                    relBegAddress = this.trans_beg_s != null ? (double)this.trans_beg_s[iTrans] / divider : (double)this.trans_beg_i[iTrans] / divider;
                    relEndAddress = this.trans_end_b != null ? relBegAddress + (double)this.trans_end_b[iTrans] / divider : (this.trans_end_s != null ? relBegAddress + (double)this.trans_end_s[iTrans] / divider : relBegAddress + (double)this.trans_end_i[iTrans] / divider);
                    tokenId = this.trans_tok_s != null ? this.trans_tok_s[iTrans] : this.trans_tok_i[iTrans];
                }
            }
        }
        this.trans_beg_s = null;
        this.trans_beg_i = null;
        this.trans_end_b = null;
        this.trans_end_s = null;
        this.trans_end_i = null;
        this.trans_tok_s = null;
        this.trans_tok_i = null;
    }
}

